using System.Collections.Generic;
using UnityEngine;

public class NodeManager : MonoBehaviour
{
    public static NodeManager Instance { get; private set; }

    [SerializeField] private GameObject nodePrefab;

    private Dictionary<string, Node> nodeMap = new();
    private GameObject currentNodeInstance;

    private void Awake()
    {
        if (Instance != null && Instance != this)
        {
            Destroy(gameObject);
            return;
        }
        Instance = this;
    }

    public void LoadGraph(Graph graph)
    {
        nodeMap.Clear();
        foreach (Node node in graph.nodes)
        {
            nodeMap[node.id] = node;
        }
    }

    public void ShowNode(string nodeId)
    {
        if (!nodeMap.TryGetValue(nodeId, out Node node))
        {
            Debug.LogError($"Node ID {nodeId} not found.");
            return;
        }

        if (currentNodeInstance != null)
            Destroy(currentNodeInstance);

        Vector3 position = new Vector3(node.x, node.y, node.z);
        currentNodeInstance = Instantiate(nodePrefab, position, Quaternion.identity);
    }


    public Node GetNodeById(string nodeId)
    {
        nodeMap.TryGetValue(nodeId, out Node node);
        return node;
    }
}
